#!/bin/bash

YELLOW='\033[0;33m'
GREEN='\033[0;32m'
RED='\033[0;31m'
NC='\033[0m'

spinner() {
    local pid=$1
    local delay=0.1
    local spinstr='|/-\'
    while kill -0 $pid 2>/dev/null; do
        local temp=${spinstr#?}
        printf " ${YELLOW}[%c]${NC}  " "$spinstr"
        spinstr=$temp${spinstr%"$temp"}
        sleep $delay
        printf "\b\b\b\b\b\b"
    done
    printf "     \b\b\b\b\b"
}

dump_table() {
    local table_name="$1"
    local output_file="$2"

    echo "Table $table_name is dumping..."

    PGPASSWORD="$password" pg_dump --format=c -t "$table_name" "$db_name" -U "$user" -h "$host" -p "$port" > "$output_file" 2>/dev/null &
    local dump_pid=$!

    spinner "$dump_pid"
    wait "$dump_pid"

    if [ $? -eq 0 ]; then
        echo -e "${GREEN}Table $table_name was dumped successfully${NC}"
    else
        echo -e "${RED}Error dumping table $table_name${NC}"
        exit 1
    fi
}

dump_table_with_psql() {
    local table_name="$1"
    local output_file="$2"

    echo "Table $table_name is dumping..."

    PGPASSWORD="$password" psql -U "$user" -d "$db_name" -t -A -F"," -c "SELECT * FROM $table_name;" -h "$host" -p "$port" > "$output_file" &
    local psql_pid=$!

    spinner "$psql_pid"
    wait "$psql_pid"

    if [ $? -eq 0 ]; then
        echo -e "${GREEN}Table $table_name was dumped successfully${NC}"
    else
        echo -e "${RED}Error dumping table $table_name via psql${NC}"
        exit 1
    fi
}

host=$1
user=$2
password=$3
db_name=$4
port=$5

rm -rf dumps
mkdir dumps -p

dump_table "evi.access_level_controller" "./dumps/access_level_controller.sql"
dump_table "evi.access_level_worker" "./dumps/access_level_worker.sql"
dump_table "evi.access_pattern" "./dumps/access_pattern.sql"
dump_table "evi.access_pattern_relay" "./dumps/access_pattern_relay.sql"
dump_table "evi.access_views" "./dumps/access_views.sql"
dump_table "evi.apikey" "./dumps/apikey.sql"
dump_table "evi.calendar" "./dumps/calendar.sql"
dump_table "evi.calendar_dates" "./dumps/calendar_dates.sql"
dump_table "evi.calendar_day_time" "./dumps/calendar_day_time.sql"
dump_table_with_psql "evi.camera" "./dumps/camera.csv"
dump_table "evi.camera_archive_schedule" "./dumps/camera_archive_schedule.sql"
dump_table "evi.camera_stream" "./dumps/camera_stream.sql"
dump_table "evi.car" "./dumps/car.sql"
dump_table "evi.card" "./dumps/card.sql"
dump_table "evi.cell_views" "./dumps/cell_views.sql"
dump_table "evi.controller" "./dumps/controller.sql"
dump_table_with_psql "evi.discrete_input" "./dumps/discrete_input.csv"
dump_table "evi.divisions" "./dumps/divisions.sql"
dump_table "evi.entity_plan_position" "./dumps/entity_plan_position.sql"
dump_table_with_psql "evi.guest" "./dumps/guest.csv"
dump_table_with_psql "evi.guest_pass_event" "./dumps/guest_pass_event.csv"
dump_table "evi.interactive_plan" "./dumps/interactive_plan.sql"
dump_table "evi.license_params" "./dumps/license_params.sql"
dump_table "evi.location" "./dumps/location.sql"
dump_table_with_psql "evi.operational_event" "./dumps/operational_event.csv"
dump_table "evi.organizations" "./dumps/organizations.sql"
dump_table_with_psql "evi.pass_event" "./dumps/pass_event.csv"
dump_table "evi.pass_info" "./dumps/pass_info.sql"
dump_table "evi.photo" "./dumps/photo.sql"
dump_table "evi.positions" "./dumps/positions.sql"
dump_table "evi.reader" "./dumps/reader.sql"
dump_table "evi.relay" "./dumps/relay.sql"
dump_table "evi.schedule" "./dumps/schedule.sql"
dump_table "evi.settings" "./dumps/settings.sql"
dump_table "evi.token" "./dumps/token.sql"
dump_table "evi.user_log" "./dumps/user_log.sql"
dump_table_with_psql "evi.users" "./dumps/users.csv"
dump_table "evi.views" "./dumps/views.sql"
dump_table_with_psql "evi.visit" "./dumps/visit.csv"
dump_table "evi.visit_card" "./dumps/visit_card.sql"
dump_table "evi.visit_card_history" "./dumps/visit_card_history.sql"
dump_table_with_psql "evi.worker" "./dumps/worker.csv"
dump_table "evi.worker_access_pattern" "./dumps/worker_access_pattern.sql"
dump_table "evi.worker_calendar" "./dumps/worker_calendar.sql"
dump_table "evi.worker_car" "./dumps/worker_car.sql"
dump_table "evi.worker_card" "./dumps/worker_card.sql"
dump_table "evi.worker_urv" "./dumps/worker_urv.sql"
dump_table_with_psql "actions" "./dumps/actions.csv"
dump_table "faces" "./dumps/faces.sql"
dump_table_with_psql "points" "./dumps/points.csv"
dump_table_with_psql "stream_params" "./dumps/stream_params.csv"
dump_table_with_psql "streams" "./dumps/streams.csv"
dump_table_with_psql "zones" "./dumps/zones.csv"

exit 0
