import sys
import uuid
from uuid import UUID
import json
import csv

def main():
    input_file = sys.argv[1]
    output_file = sys.argv[2]

    with open(input_file, mode="r") as f, \
         open(output_file, mode="w") as dump_psql:

        csv_reader = csv.reader(f)

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.analytics_schedule
        (
            stream text COLLATE pg_catalog."default" NOT NULL,
            mode boolean NOT NULL,
            model text COLLATE pg_catalog."default" NOT NULL,
            type text COLLATE pg_catalog."default" NOT NULL,
            schedule text COLLATE pg_catalog."default" NOT NULL,
            CONSTRAINT analytics_schedule_stream_fkey FOREIGN KEY (stream)
                REFERENCES evi.streams (uuid) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        for row in csv_reader:
            if not row:
                continue

            for elem in [("faceModel", "recognition"), ("plateModel", "recognition"), ("objectModel", "crossLine"),
            ("objectModel", "enterZone"), ("objectModel", "exitZone")]:
                data = [
                    {
                        "day":"sunday",
                        "timeList":[
                            {
                                "end":"23:59:59",
                                "start":"00:00:00",
                                "type":False
                            }
                        ]
                    },
                    {
                        "day":"monday",
                        "timeList":[
                            {
                                "end":"23:59:59",
                                "start":"00:00:00",
                                "type":False
                            }
                        ]
                    },
                    {
                        "day":"tuesday",
                        "timeList":[
                            {
                                "end":"23:59:59",
                                "start":"00:00:00",
                                "type":False
                            }
                        ]
                    },
                    {
                        "day":"wednesday",
                        "timeList":[
                            {
                                "end":"23:59:59",
                                "start":"00:00:00",
                                "type":False
                            }
                        ]
                    },
                    {
                        "day":"thursday",
                        "timeList":[
                            {
                                "end":"23:59:59",
                                "start":"00:00:00",
                                "type":False
                            }
                        ]
                    },
                    {
                        "day":"friday",
                        "timeList":[
                            {
                                "end":"23:59:59",
                                "start":"00:00:00",
                                "type":False
                            }
                        ]
                    },
                    {
                        "day":"saturday",
                        "timeList":[
                            {
                                "end":"23:59:59",
                                "start":"00:00:00",
                                "type":False
                            }
                        ]
                    }
                ]

                dump_psql.write(f"""
                INSERT INTO evi.analytics_schedule (stream, mode, model, type, schedule)
                VALUES ('{row[0]}',
                        false,
                        '{elem[0]}',
                        '{elem[1]}',
                        '{str(json.dumps(data))}');
                \n""")

if __name__ == "__main__":
    main()