import sys
import csv

class CameraRecord:
    def __init__(self, camera_id, name, display_label, location, analytics, tcp, enabled, sensitivity, gap_time, grid, grid_x, grid_y, mode,
    archive_days, login, password, port):
        self.camera_id = camera_id
        self.name = name
        self.display_label = display_label
        self.location = location
        self.analytics = analytics
        self.tcp = tcp
        self.enabled = enabled
        self.sensitivity = sensitivity
        self.gap_time = gap_time
        self.grid = grid
        self.grid_x = grid_x
        self.grid_y = grid_y
        self.mode = mode
        self.archive_days = archive_days
        self.login = login
        self.password = password
        self.port = port

def parse_csv_row(row):
    head_fields = row[:9]
    tail_fields = row[-7:]

    grid_str = ",".join(row[9:-7])

    return tuple(head_fields) + (grid_str,) + tuple(tail_fields)

def main():
    input_file = sys.argv[1]
    output_file = sys.argv[2]

    with open(input_file, mode="r") as f, \
         open(output_file, mode="w") as dump_psql:

        csv_reader = csv.reader(f)

        dump_psql.write("""
            CREATE TABLE evi.camera
            (
                camera_id text COLLATE pg_catalog."default" NOT NULL,
                location text COLLATE pg_catalog."default",
                name text COLLATE pg_catalog."default" NOT NULL,
                display_label boolean NOT NULL,
                analytics boolean NOT NULL,
                tcp boolean NOT NULL,
                enabled boolean NOT NULL,
                sensitivity real NOT NULL,
                gap_time integer NOT NULL,
                grid text COLLATE pg_catalog."default" NOT NULL,
                grid_x integer NOT NULL,
                grid_y integer NOT NULL,
                mode integer NOT NULL,
                archive_days integer NOT NULL,
                pre_buffer integer NOT NULL DEFAULT 5,
                login text COLLATE pg_catalog."default",
                password text COLLATE pg_catalog."default",
                port text COLLATE pg_catalog."default",
                max_object_count integer NOT NULL DEFAULT 20,
                active_md boolean NOT NULL DEFAULT false,
                CONSTRAINT camera_pkey PRIMARY KEY (camera_id),
                CONSTRAINT camera_location_fkey FOREIGN KEY (location)
                    REFERENCES evi.location (location_id) MATCH SIMPLE
                    ON UPDATE NO ACTION
                    ON DELETE SET NULL
            );
        \n""")

        for row in csv_reader:
            if not row:
                continue

            try:
                (camera_id, name, display_label, location, analytics, tcp, enabled,
                sensitivity, gap_time, grid, grid_x, grid_y, mode, archive_days,
                login, password, port) = parse_csv_row(row)
            except Exception as e:
                print("Ошибка парсинга:", e)
                print("Проблемная строка:", row)
                return 1

            grid = grid.strip()

            if display_label == "t":
                display_label = "true"
            else:
                display_label = "false"

            if analytics == "t":
                analytics = "true"
            else:
                analytics = "false"

            if tcp == "t":
                tcp = "true"
            else:
                tcp = "false"

            if enabled == "t":
                enabled = "true"
            else:
                enabled = "false"

            record = CameraRecord(
                camera_id,
                name,
                display_label,
                location,
                analytics,
                tcp,
                enabled,
                sensitivity,
                gap_time,
                grid,
                grid_x,
                grid_y,
                mode,
                archive_days,
                login,
                password,
                port
            )

            dump_psql.write(f"""INSERT INTO evi.camera (camera_id, name, display_label, location, analytics, tcp,
                            enabled, sensitivity, gap_time, grid, grid_x, grid_y, mode, archive_days, login, password, port)
                            VALUES ('{record.camera_id}', '{record.name}', {record.display_label}, '{record.location}', {record.analytics}, {record.tcp},
                            {record.enabled}, {0.01}, {record.gap_time}, '{record.grid}', {record.grid_x}, {record.grid_y},
                            {0}, {record.archive_days}, '{record.login}', '{record.password}', '{record.port}');\n""")

if __name__ == "__main__":
    main()
