import sys

class DIRecord:
    def __init__(self, dinput_id, controller, di_num, type, trigger):
        self.dinput_id = dinput_id
        self.controller = controller
        self.di_num = di_num
        self.type = type
        self.trigger = trigger

f = open(sys.argv[1], mode="r")

dump_file = open(sys.argv[2], mode="w")

rows = f.read().split("\n")

dump_file.write("""
    CREATE TABLE evi.discrete_input
    (
        dinput_id text COLLATE pg_catalog."default" NOT NULL,
        controller text COLLATE pg_catalog."default" NOT NULL,
        di_num integer NOT NULL,
        type text COLLATE pg_catalog."default" NOT NULL,
        trigger boolean NOT NULL,
        notification boolean NOT NULL DEFAULT true,
        timeout bigint NOT NULL DEFAULT 5,
        CONSTRAINT discrete_input_pkey PRIMARY KEY (dinput_id),
        CONSTRAINT discrete_input_controller_fkey FOREIGN KEY (controller)
            REFERENCES evi.controller (controller_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE CASCADE
    );
\n""")

for row in rows:
    if len(row) == 0:
        continue

    cols = row.split(",")
    record = DIRecord(cols[0], cols[1], cols[2], cols[3], cols[4])

    if record.trigger == "t":
        record.trigger = "true"
    else:
        record.trigger = "false"

    dump_file.write(f"""INSERT INTO evi.discrete_input (dinput_id, controller, di_num, type, trigger)
                    VALUES ('{record.dinput_id}', '{record.controller}', {record.di_num}, '{record.type}', {record.trigger});\n""")
