import sys

class GuestRecord:
    def __init__(self, guest_id, last_name, first_name, patronymic, organization, comment, photo, analytics):
        self.guest_id = guest_id
        self.last_name = last_name
        self.first_name = first_name
        self.patronymic = patronymic
        self.organization = organization
        self.comment = comment
        self.photo = photo
        self.analytics = analytics

f = open(sys.argv[1], mode="r")

dump_file = open(sys.argv[2], mode="w")

rows = f.read().split("\n")

dump_file.write("""
    CREATE TABLE evi.guest
    (
        guest_id text COLLATE pg_catalog."default" NOT NULL,
        last_name text COLLATE pg_catalog."default" NOT NULL,
        first_name text COLLATE pg_catalog."default" NOT NULL,
        patronymic text COLLATE pg_catalog."default" NOT NULL,
        organization text COLLATE pg_catalog."default" NOT NULL,
        comment text COLLATE pg_catalog."default",
        mobile text COLLATE pg_catalog."default",
        email text COLLATE pg_catalog."default",
        birth_date text COLLATE pg_catalog."default",
        photo text COLLATE pg_catalog."default",
        analytics boolean NOT NULL,
        CONSTRAINT guest_pkey PRIMARY KEY (guest_id),
        CONSTRAINT guest_photo_fkey FOREIGN KEY (photo)
            REFERENCES evi.photo (photo_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE SET NULL
    );
\n""")

for row in rows:
    if len(row) == 0:
        continue

    cols = row.split(",")
    record = GuestRecord(cols[0], cols[1], cols[2], cols[3], cols[4], cols[5], cols[6], cols[7])

    photo_str = f"'{record.photo}'" if record.photo else "NULL"

    if record.analytics == "t":
        record.analytics = "true"
    else:
        record.analytics = "false"

    dump_file.write(f"""INSERT INTO evi.guest (guest_id, last_name, first_name, patronymic, organization, comment, photo, analytics)
                    VALUES ('{record.guest_id}', '{record.last_name}', '{record.first_name}', '{record.patronymic}', '{record.organization}',
                    '{record.comment}', {photo_str}, {record.analytics});\n""")
