import sys
import uuid
from uuid import UUID
import json
import csv

class GuestPassRecord:
    def __init__(self, id, payload, timestamp):
        self.id = id
        self.payload = payload
        self.timestamp = timestamp

def parse_csv_row(row):
    id_field = str(uuid.uuid4())
    tail_fields = row[-1:]

    # JSON-поле — всё между первым и последним
    payload_json_str = ",".join(row[1:-1])

    return id_field, payload_json_str, *tail_fields


def main():
    input_file = sys.argv[1]
    output_file = sys.argv[2]

    with open(input_file, mode="r") as f, \
         open(output_file, mode="w") as dump_psql:

        csv_reader = csv.reader(f)

        dump_psql.write("""
            CREATE TABLE evi.guest_pass_event
            (
                id text COLLATE pg_catalog."default" NOT NULL,
                payload jsonb NOT NULL,
                "timestamp" timestamp with time zone NOT NULL,
                CONSTRAINT guest_pass_event_pkey PRIMARY KEY (id)
            );
        \n""")

        for row in csv_reader:
            if not row:
                continue

            try:
                id_field, payload_str, timestamp = parse_csv_row(row)
            except Exception as e:
                print("Ошибка парсинга:", e)
                print("Проблемная строка:", row)
                return 1

            payload_str = payload_str.strip()

            record = GuestPassRecord(
                id_field,
                payload_str,
                timestamp[:-3]
            )

            dump_psql.write(f"""
                INSERT INTO evi.guest_pass_event (id, payload, "timestamp")
                VALUES ('{record.id}',
                        '{record.payload.replace("'", "''")}',
                        '{record.timestamp}');
            \n""")

if __name__ == "__main__":
    main()