import sys
import uuid
from uuid import UUID
import json
import csv

class OperationalEventRecord:
    def __init__(self, id, payload, timestamp, confirmed, user_login, user_id):
        self.id = id
        self.payload = payload
        self.timestamp = timestamp
        self.confirmed = confirmed
        self.user_login = user_login
        self.user_id = user_id

class ClickhouseRecord:
    def __init__(self, id, timestamp, code, level, controller="", location="", user="", relay="", di="", camera="", cameraStream="",
                 card="", car="", worker="", guest="", prevCard="", prevWorker="", prevGuest="", prevDi="", service="", updateTask=""):
        self.id = id
        self.timestamp = timestamp
        self.code = code
        self.level = level
        self.controller = controller
        self.location = location
        self.user = user
        self.relay = relay
        self.di = di
        self.camera = camera
        self.cameraStream = cameraStream
        self.card = card
        self.car = car
        self.worker = worker
        self.guest = guest
        self.prevCard = prevCard
        self.prevWorker = prevWorker
        self.prevGuest = prevGuest
        self.prevDi = prevDi
        self.service = service
        self.updateTask = updateTask


def parse_csv_row(row):
    id_field = str(uuid.uuid4())
    tail_fields = row[-4:]

    # JSON-поле — всё между первым и последними четырьмя
    payload_json_str = ",".join(row[1:-4])

    return id_field, payload_json_str, *tail_fields


def main():
    input_file = sys.argv[1]
    psql_output_file = sys.argv[2]
    ch_output_file = sys.argv[3]

    with open(input_file, mode="r") as f, \
         open(psql_output_file, mode="w") as dump_psql, \
         open(ch_output_file, mode="w", newline='') as dump_ch:

        csv_reader = csv.reader(f)
        writer = csv.writer(dump_ch)

        dump_psql.write("""
            CREATE TABLE IF NOT EXISTS evi.critical_event (
                id text COLLATE pg_catalog."default" NOT NULL,
                payload jsonb NOT NULL,
                "timestamp" timestamp with time zone NOT NULL,
                confirmed boolean,
                user_login text COLLATE pg_catalog."default",
                user_id text COLLATE pg_catalog."default",
                CONSTRAINT critical_event_pkey PRIMARY KEY (id),
                CONSTRAINT unique_ev UNIQUE ("timestamp", payload)
            );
        \n""")

        for row in csv_reader:
            if not row:
                continue

            try:
                id_field, payload_str, timestamp, confirmed, user_login, user_id = parse_csv_row(row)
            except Exception as e:
                print("Ошибка парсинга:", e)
                print("Проблемная строка:", row)
                return 1

            payload_str = payload_str.strip()

            if confirmed == "t":
                confirmed = "true"
            elif confirmed == "f":
                confirmed = "false"

            record = OperationalEventRecord(
                id_field,
                payload_str,
                timestamp[:-3],
                confirmed,
                user_login,
                user_id
            )

            if record.confirmed:
                dump_psql.write(f"""
                    INSERT INTO evi.critical_event (id, payload, "timestamp", confirmed, user_login, user_id)
                    VALUES ('{record.id}', '{record.payload.replace("'", "''")}', '{record.timestamp}',
                            {record.confirmed},
                            {f"'{record.user_login}'" if record.user_login else 'NULL'},
                            {f"'{record.user_id}'" if record.user_id else 'NULL'});
                \n""")

            try:
                payload_json = json.loads(record.payload)
            except json.JSONDecodeError as e:
                print("Ошибка декодирования JSON:", record.payload)
                continue

            ch_record = ClickhouseRecord(
                UUID(record.id).bytes.hex(),
                record.timestamp,
                payload_json.get('code'),
                payload_json.get('level')
            )

            for entity in payload_json.get('entity', []):
                t = entity.get('type')
                j = json.dumps(entity)
                if t == 'controller':
                    ch_record.controller = j
                if t == 'location':
                    ch_record.location = j
                if t == 'user':
                    ch_record.user = j
                if t == 'relay':
                    ch_record.relay = j
                if t == 'di':
                    ch_record.di = j
                if t == 'camera':
                    ch_record.camera = j
                if t == 'cameraStream':
                    ch_record.cameraStream = j
                if t == 'card':
                    ch_record.card = j
                if t == 'car':
                    ch_record.car = j
                if t == 'worker':
                    ch_record.worker = j
                if t == 'guest':
                    ch_record.guest = j
                if t == 'prevCard':
                    ch_record.prevCard = j
                if t == 'prevWorker':
                    ch_record.prevWorker = j
                if t == 'prevGuest':
                    ch_record.prevGuest = j
                if t == 'prevDi':
                    ch_record.prevDi = j
                if t == 'service':
                    ch_record.service = j
                if t == 'updateTask':
                    ch_record.updateTask = j

            writer.writerow(vars(ch_record).values())

if __name__ == "__main__":
    main()