import sys
import uuid
from uuid import UUID
import json
import csv

class PointsRecord:
    def __init__(self, uuid, stream, index, x, y):
        self.uuid = uuid
        self.stream = stream
        self.index = index
        self.x = x
        self.y = y

class ZonesRecord:
    def __init__(self, uuid, name, stream, for_faces, for_numbers, for_other):
        self.uuid = uuid
        self.name = name
        self.stream = stream
        self.for_faces = for_faces
        self.for_numbers = for_numbers
        self.for_other = for_other

def main():
    points_input_file = sys.argv[1]
    zones_input_file = sys.argv[2]
    output_file = sys.argv[3]

    with open(points_input_file, mode="r") as points_f, \
         open(zones_input_file, mode="r") as zones_f, \
         open(output_file, mode="w") as dump_psql:

        points_csv_reader = csv.reader(points_f)
        zones_csv_reader = csv.reader(zones_f)

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.masks
        (
            uuid text COLLATE pg_catalog."default" NOT NULL,
            name text COLLATE pg_catalog."default" NOT NULL,
            stream text COLLATE pg_catalog."default" NOT NULL,
            handlers text COLLATE pg_catalog."default" NOT NULL,
            CONSTRAINT masks_pkey PRIMARY KEY (uuid),
            CONSTRAINT masks_stream_fkey FOREIGN KEY (stream)
                REFERENCES evi.streams (uuid) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.maskspoints
        (
            uuid text COLLATE pg_catalog."default" NOT NULL,
            index integer NOT NULL,
            x real NOT NULL,
            y real NOT NULL,
            CONSTRAINT maskspoints_uuid_fkey FOREIGN KEY (uuid)
                REFERENCES evi.masks (uuid) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.zones
        (
            uuid text COLLATE pg_catalog."default" NOT NULL,
            name text COLLATE pg_catalog."default" NOT NULL,
            stream text COLLATE pg_catalog."default" NOT NULL,
            direction integer NOT NULL,
            CONSTRAINT zones_pkey PRIMARY KEY (uuid),
            CONSTRAINT zones_stream_fkey FOREIGN KEY (stream)
                REFERENCES evi.streams (uuid) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.zonepoints
        (
            uuid text COLLATE pg_catalog."default" NOT NULL,
            index integer NOT NULL,
            x real NOT NULL,
            y real NOT NULL,
            CONSTRAINT zonepoints_uuid_fkey FOREIGN KEY (uuid)
                REFERENCES evi.zones (uuid) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        for zone_row in zones_csv_reader:
            if not zone_row:
                continue

            record = ZonesRecord(
                zone_row[0],
                zone_row[1],
                zone_row[2],
                zone_row[4],
                zone_row[5],
                zone_row[6]
            )

            if record.for_faces == "t":
                handlers = "{\"handle_faces\": true, \"handle_plates\": false}"
                dump_psql.write(f"""
                INSERT INTO evi.masks (uuid, name, stream, handlers)
                VALUES ('{record.uuid}',
                        '{record.name}',
                        '{record.stream}',
                        '{handlers}');
                \n""")

                for point_row in points_csv_reader:
                    if not point_row:
                        continue

                    point_record = PointsRecord(
                        point_row[0],
                        point_row[1],
                        point_row[2],
                        point_row[3],
                        point_row[4]
                    )

                    if point_record.uuid != record.uuid:
                        continue

                    dump_psql.write(f"""
                    INSERT INTO evi.masksPoints (uuid, index, x, y)
                    VALUES ('{point_record.uuid}',
                            {point_record.index},
                            {point_record.x},
                            {point_record.y});
                    \n""")

            if record.for_numbers == "t":
                handlers = "{\"handle_faces\": false, \"handle_plates\": true}"
                dump_psql.write(f"""
                INSERT INTO evi.masks (uuid, name, stream, handlers)
                VALUES ('{record.uuid}',
                        '{record.name}',
                        '{record.stream}',
                        '{handlers}');
                \n""")

                for point_row in points_csv_reader:
                    if not point_row:
                        continue

                    point_record = PointsRecord(
                        point_row[0],
                        point_row[1],
                        point_row[2],
                        point_row[3],
                        point_row[4]
                    )

                    if point_record.uuid != record.uuid:
                        continue

                    dump_psql.write(f"""
                    INSERT INTO evi.masksPoints (uuid, index, x, y)
                    VALUES ('{point_record.uuid}',
                            {point_record.index},
                            {point_record.x},
                            {point_record.y});
                    \n""")

            if record.for_other == "t":
                dump_psql.write(f"""
                INSERT INTO evi.zones (uuid, name, stream, direction)
                VALUES ('{record.uuid}',
                        '{record.name}',
                        '{record.stream}',
                        0);
                \n""")

                for point_row in points_csv_reader:
                    if not point_row:
                        continue

                    point_record = PointsRecord(
                        point_row[0],
                        point_row[1],
                        point_row[2],
                        point_row[3],
                        point_row[4]
                    )

                    if point_record.uuid != record.uuid:
                        continue

                    dump_psql.write(f"""
                    INSERT INTO evi.zonePoints (uuid, index, x, y)
                    VALUES ('{point_record.uuid}',
                            {point_record.index},
                            {point_record.x},
                            {point_record.y});
                    \n""")

            points_f.seek(0)

if __name__ == "__main__":
    main()