import sys
import uuid
from uuid import UUID
import json
import csv

class StreamParamsRecord:
    def __init__(self, stream, name, value):
        self.stream = stream
        self.name = name
        self.value = value

def main():
    input_file = sys.argv[1]
    output_file = sys.argv[2]

    with open(input_file, mode="r") as f, \
         open(output_file, mode="w") as dump_psql:

        csv_reader = csv.reader(f)

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.stream_params
        (
            stream text COLLATE pg_catalog."default" NOT NULL,
            parameters text COLLATE pg_catalog."default" NOT NULL,
            CONSTRAINT stream_params_stream_fkey FOREIGN KEY (stream)
                REFERENCES evi.streams (uuid) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        uuids = {}

        for row in csv_reader:
            if not row:
                continue

            record = StreamParamsRecord(
                row[0],
                row[1],
                row[2]
            )

            if record.stream not in uuids:
                uuids[record.stream] = {}

            uuids[record.stream][record.name] = record.value

        print(uuids.keys())

        for stream_id, params in uuids.items():
            if "n_error_symbols" not in params:
                params["n_error_symbols"] = 0

            data = {
                "car_min_box_height":{
                    "line": float(params["o_min_box_height"]),
                    "zone_in": float(params["o_min_box_height"]),
                    "zone_out": float(params["o_min_box_height"])
                },
                "car_threshold":{
                    "line": float(params["o_sens"]),
                    "zone_in": float(params["o_sens"]),
                    "zone_out": float(params["o_sens"])
                },
                "face_intent_tolerance": 0.6,
                "face_min_box_height": float(params["f_min_box_height"]),
                "face_threshold": float(params["f_sens"]),
                "face_tolerance": float(params["f_tolerance"]),
                "human_min_box_height":{
                    "line":0.01,
                    "zone_in":0.01,
                    "zone_out":0.01
                },
                "human_threshold":{
                    "line":0.5,
                    "zone_in":0.5,
                    "zone_out":0.5
                },
                "object_min_box_height":{
                    "line":0.01,
                    "zone_in":0.01,
                    "zone_out":0.01
                },
                "object_threshold":{
                    "line":0.5,
                    "zone_in":0.5,
                    "zone_out":0.5
                },
                "plate_error_symbols": int(params["n_error_symbols"]),
                "plate_min_box_height": float(params["n_min_box_height"]),
                "plate_threshold": float(params["n_sens"])
            }

            dump_psql.write(f"""
            INSERT INTO evi.stream_params (stream, parameters)
            VALUES ('{stream_id}',
                    '{str(json.dumps(data))}');
            \n""")

if __name__ == "__main__":
    main()