import sys
import uuid
from uuid import UUID
import json
import csv

class StreamRecord:
    def __init__(self, uuid, name, analytics, handle_faces, handle_numbers, handle_other, enable_lines, enable_zones, decoder):
        self.uuid = uuid
        self.name = name
        self.analytics = analytics
        self.handle_faces = handle_faces
        self.handle_numbers = handle_numbers
        self.handle_other = handle_other
        self.enable_lines = enable_lines
        self.enable_zones = enable_zones
        self.decoder = decoder

def main():
    input_file = sys.argv[1]
    output_file = sys.argv[2]

    with open(input_file, mode="r") as f, \
         open(output_file, mode="w") as dump_psql:

        csv_reader = csv.reader(f)

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.streams
        (
            uuid text COLLATE pg_catalog."default" NOT NULL,
            name text COLLATE pg_catalog."default" NOT NULL,
            handlers jsonb NOT NULL,
            decoder text COLLATE pg_catalog."default" NOT NULL,
            CONSTRAINT streams_pkey PRIMARY KEY (uuid),
            CONSTRAINT streams_uuid_fkey FOREIGN KEY (uuid)
                REFERENCES evi.camera (camera_id) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        for row in csv_reader:
            if not row:
                continue

            record = StreamRecord(
                row[0],
                row[1],
                row[2],
                row[3],
                row[4],
                row[5],
                row[6],
                row[7],
                row[8]
            )

            data = {
                "car_executors":{
                    "enabled":True if record.handle_other == "t" else False,
                    "line":False,
                    "zone_in":True if record.handle_other == "t" else False,
                    "zone_out":False
                },
                "handle_faces":True if record.handle_faces == "t" else False,
                "human_executors":{
                    "enabled":False,
                    "line":False,
                    "zone_in":False,
                    "zone_out":False
                },
                "other_executors":{
                    "enabled":False,
                    "line":False,
                    "zone_in":False,
                    "zone_out":False
                },
                "handle_plates":True if record.handle_numbers == "t" else False,
                "handle_line":False,
                "handle_zone_in":True if record.handle_other == "t" else False,
                "handle_zone_out":False
            }

            dump_psql.write(f"""
            INSERT INTO evi.streams (uuid, name, handlers, decoder)
            VALUES ('{record.uuid}',
                    '{record.name}',
                    '{str(json.dumps(data))}',
                    '{record.decoder}');
            \n""")

if __name__ == "__main__":
    main()