import sys
import uuid
from uuid import UUID
import json
import csv

class CameraRecord:
    def __init__(self, camera_id, name, display_label, location, analytics, tcp, enabled, sensitivity, gap_time, grid, grid_x, grid_y, mode,
    archive_days, login, password, port):
        self.camera_id = camera_id
        self.name = name
        self.display_label = display_label
        self.location = location
        self.analytics = analytics
        self.tcp = tcp
        self.enabled = enabled
        self.sensitivity = sensitivity
        self.gap_time = gap_time
        self.grid = grid
        self.grid_x = grid_x
        self.grid_y = grid_y
        self.mode = mode
        self.archive_days = archive_days
        self.login = login
        self.password = password
        self.port = port

class CameraAnalyticsTriggerRecord:
    def __init__(self, name, active, type, model, with_workers, params, camera):
        self.trigger_id = str(uuid.uuid4())
        self.name = name
        self.active = active
        self.type = type
        self.model = model
        self.with_workers = with_workers
        self.params = params
        self.camera = camera

class ZonesRecord:
    def __init__(self, uuid, name, stream, for_faces, for_numbers, for_other):
        self.uuid = uuid
        self.name = name
        self.stream = stream
        self.for_faces = for_faces
        self.for_numbers = for_numbers
        self.for_other = for_other

def parse_csv_row_camera(row):
    head_fields = row[:9]
    tail_fields = row[-7:]

    grid_str = ",".join(row[9:-7])

    return tuple(head_fields) + (grid_str,) + tuple(tail_fields)

def parse_csv_row_action(row):
    head_fields = row[:3]

    action_str = ",".join(row[3:])

    action_str = action_str.replace('state:', '"state":')
    action_str = action_str.replace(',type:', ',"type":')

    return *head_fields, action_str

def main():
    camera_input = sys.argv[1]
    actions_input = sys.argv[2]
    zones_input = sys.argv[3]
    output_file = sys.argv[4]

    with open(camera_input, mode="r") as camera_input_f, \
         open(actions_input, mode="r") as actions_input_f, \
         open(zones_input, mode="r") as zones_input_f, \
         open(output_file, mode="w") as dump_psql:

        camera_reader = csv.reader(camera_input_f)
        actions_reader = csv.reader(actions_input_f)
        zones_reader = csv.reader(zones_input_f)

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.camera_analytics_triggers
        (
            trigger_id text COLLATE pg_catalog."default" NOT NULL,
            name text COLLATE pg_catalog."default" NOT NULL,
            active boolean NOT NULL,
            type text COLLATE pg_catalog."default" NOT NULL,
            model text COLLATE pg_catalog."default" NOT NULL,
            with_workers boolean NOT NULL,
            params jsonb NOT NULL,
            camera text COLLATE pg_catalog."default",
            CONSTRAINT camera_analytics_triggers_pkey PRIMARY KEY (trigger_id),
            CONSTRAINT camera_analytics_triggers_camera_fkey FOREIGN KEY (camera)
                REFERENCES evi.camera (camera_id) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.camera_analytics_record_archive
        (
            trigger text COLLATE pg_catalog."default",
            gap bigint NOT NULL,
            camera text COLLATE pg_catalog."default",
            CONSTRAINT camera_analytics_record_archive_camera_fkey FOREIGN KEY (camera)
                REFERENCES evi.camera (camera_id) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE,
            CONSTRAINT camera_analytics_record_archive_trigger_fkey FOREIGN KEY (trigger)
                REFERENCES evi.camera_analytics_triggers (trigger_id) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        dump_psql.write("""
        CREATE TABLE IF NOT EXISTS evi.camera_analytics_control_object
        (
            trigger text COLLATE pg_catalog."default",
            state text COLLATE pg_catalog."default" NOT NULL,
            relay text COLLATE pg_catalog."default",
            CONSTRAINT camera_analytics_control_object_relay_fkey FOREIGN KEY (relay)
                REFERENCES evi.relay (relay_id) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE,
            CONSTRAINT camera_analytics_control_object_trigger_fkey FOREIGN KEY (trigger)
                REFERENCES evi.camera_analytics_triggers (trigger_id) MATCH SIMPLE
                ON UPDATE NO ACTION
                ON DELETE CASCADE
        );
        \n""")

        cameras = {}
        zones = {}

        for zone_row in zones_reader:
            if not zone_row or len(zone_row) < 7:
                continue

            zones[zone_row[2]] = zone_row[0]

        for row in camera_reader:
            if not row:
                continue

            try:
                (camera_id, name, display_label, location, analytics, tcp, enabled,
                sensitivity, gap_time, grid, grid_x, grid_y, mode, archive_days,
                login, password, port) = parse_csv_row_camera(row)
            except Exception as e:
                print("Ошибка парсинга:", e)
                print("Проблемная строка:", row)
                return 1

            cameras[camera_id] = name

            if mode == "2":
                trigger_record = CameraAnalyticsTriggerRecord(name, "true", "detection", "motionModel", "false", """{"type":"detection"}""", camera_id)

                dump_psql.write(f"""INSERT INTO evi.camera_analytics_triggers (trigger_id, name, active, type, model, with_workers,
                    params, camera) VALUES ('{trigger_record.trigger_id}', '{trigger_record.name}', {trigger_record.active},
                                            '{trigger_record.type}', '{trigger_record.model}', {trigger_record.with_workers},
                                            '{trigger_record.params}', '{trigger_record.camera}');\n""")

                dump_psql.write(f"""INSERT INTO evi.camera_analytics_record_archive (trigger, gap, camera)
                                VALUES ('{trigger_record.trigger_id}', 5, '{trigger_record.camera}');\n""")

                dump_psql.write(f"""UPDATE evi.camera SET active_md = true where camera_id = '{trigger_record.camera}';\n""")

        for row in actions_reader:
            if not row:
                continue

            try:
                (camera_id, actor_type, event_type, action_str) = parse_csv_row_action(row)
            except Exception as e:
                print("Ошибка парсинга:", e)
                print("Проблемная строка:", row)
                return 1

            action_json = json.loads(action_str)

            model = ""
            if actor_type == "face":
                model = "faceModel"
            elif actor_type == "number":
                model = "plateModel"
            elif actor_type == "other":
                model = "objectModel"
            else:
                continue

            if (model != "objectModel"):
                trigger_record = CameraAnalyticsTriggerRecord(cameras[camera_id],
                "true", "recognition", model, "true", """{"type":"recognition"}""", camera_id)
                dump_psql.write(f"""INSERT INTO evi.camera_analytics_triggers (trigger_id, name, active, type, model, with_workers,
                params, camera) VALUES ('{trigger_record.trigger_id}', '{trigger_record.name}', {trigger_record.active},
                                        '{trigger_record.type}', '{trigger_record.model}', {trigger_record.with_workers},
                                        '{trigger_record.params}', '{trigger_record.camera}');\n""")

                dump_psql.write(f"""INSERT INTO evi.camera_analytics_control_object (trigger, state, relay)
                    VALUES ('{trigger_record.trigger_id}', 'pass', '{str(action_json["settings"]["id"])}');\n""")
            else:
                if camera_id in zones:
                    zone_uuid = zones[camera_id]

                    params = json.dumps({
                        "type": "enterZone",
                        "id": zone_uuid
                    })

                    trigger_record = CameraAnalyticsTriggerRecord(
                        cameras[camera_id],
                        "true",
                        "enterZone",
                        model,
                        "false",
                        params,
                        camera_id
                    )

                    dump_psql.write(f"""INSERT INTO evi.camera_analytics_triggers (trigger_id, name, active, type, model, with_workers,
                    params, camera) VALUES ('{trigger_record.trigger_id}', '{trigger_record.name}', {trigger_record.active},
                                            '{trigger_record.type}', '{trigger_record.model}', {trigger_record.with_workers},
                                            '{trigger_record.params}', '{trigger_record.camera}');\n""")

                    dump_psql.write(f"""INSERT INTO evi.camera_analytics_control_object (trigger, state, relay)
                    VALUES ('{trigger_record.trigger_id}', 'pass', '{str(action_json["settings"]["id"])}');\n""")
                else:
                    continue

if __name__ == "__main__":
    main()