import sys

class UserRecord:
    def __init__(self, user_id, login, password, blocked, activated, role):
        self.user_id = user_id
        self.login = login
        self.password = password
        self.blocked = blocked
        self.activated = activated
        self.role = role

f = open(sys.argv[1], mode="r")

dump_file = open(sys.argv[2], mode="w")

rows = f.read().split("\n")

dump_file.write("""
CREATE TABLE evi.users
    (
        user_id text COLLATE pg_catalog."default" NOT NULL,
        login text COLLATE pg_catalog."default" NOT NULL,
        password text COLLATE pg_catalog."default" NOT NULL,
        blocked boolean NOT NULL,
        activated boolean NOT NULL DEFAULT false,
        role text COLLATE pg_catalog."default" NOT NULL,
        last_contact timestamp with time zone,
        CONSTRAINT users_pkey PRIMARY KEY (user_id),
        CONSTRAINT users_login_key UNIQUE (login)
    );
\n""")

for row in rows:
    if len(row) == 0:
        continue

    cols = row.split(",")
    record = UserRecord(cols[0], cols[1], cols[2], cols[3], cols[4], cols[5])

    if record.blocked == "f":
        record.blocked = "false"
    else:
        record.blocked = "true"

    if record.activated == "f":
        record.activated = "false"
    else:
        record.activated = "true"

    dump_file.write(f"""INSERT INTO evi.users (user_id, login, password, blocked, activated, role)
                    VALUES ('{record.user_id}', '{record.login}', '{record.password}', {record.blocked}, {record.activated}, '{record.role}');\n""")
