import sys

class VisitRecord:
    def __init__(self, visit_id, guest, date_start, date_end, escort, status):
        self.visit_id = visit_id
        self.guest = guest
        self.date_start = date_start
        self.date_end = date_end
        self.escort = escort
        self.status = status

f = open(sys.argv[1], mode="r")

dump_file = open(sys.argv[2], mode="w")

rows = f.read().split("\n")

dump_file.write("""
    CREATE TABLE IF NOT EXISTS evi.visit_purposes
    (
        visit_purpose_id text COLLATE pg_catalog."default" NOT NULL,
        name text COLLATE pg_catalog."default" NOT NULL,
        CONSTRAINT visit_purposes_pkey PRIMARY KEY (visit_purpose_id),
        CONSTRAINT visit_purposes_name_key UNIQUE (name)
    );

    CREATE TABLE evi.visit
    (
        visit_id text COLLATE pg_catalog."default" NOT NULL,
        guest text COLLATE pg_catalog."default",
        date_start timestamp with time zone NOT NULL,
        date_end timestamp with time zone NOT NULL,
        escort text COLLATE pg_catalog."default",
        visit_purpose text COLLATE pg_catalog."default",
        status text COLLATE pg_catalog."default" NOT NULL,
        CONSTRAINT visit_pkey PRIMARY KEY (visit_id),
        CONSTRAINT visit_escort_fkey FOREIGN KEY (escort)
            REFERENCES evi.worker (worker_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE SET NULL,
        CONSTRAINT visit_guest_fkey FOREIGN KEY (guest)
            REFERENCES evi.guest (guest_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE CASCADE,
        CONSTRAINT visit_visit_purpose_fkey FOREIGN KEY (visit_purpose)
            REFERENCES evi.visit_purposes (visit_purpose_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE SET NULL
    );
\n""")

for row in rows:
    if len(row) == 0:
        continue

    cols = row.split(",")
    record = VisitRecord(cols[0], cols[1], cols[2], cols[3], cols[4], cols[6])

    dump_file.write(f"""INSERT INTO evi.visit (visit_id, guest, date_start, date_end, escort, status)
                    VALUES ('{record.visit_id}', '{record.guest}', '{record.date_start}', '{record.date_end}',
                    '{record.escort}', '{record.status}');\n""")
