import sys

class WorkerRecord:
    def __init__(self, worker_id, last_name, first_name, patronymic, organization, division, position, employment_date, dismissal_date, status,
    mobile, email, photo, last_location, analytics, access_level):
        self.worker_id = worker_id
        self.last_name = last_name
        self.first_name = first_name
        self.patronymic = patronymic
        self.organization = organization
        self.division = division
        self.position = position
        self.employment_date = employment_date
        self.dismissal_date = dismissal_date
        self.status = status
        self.mobile = mobile
        self.email = email
        self.photo = photo
        self.last_location = last_location
        self.analytics = analytics
        self.access_level = access_level

f = open(sys.argv[1], mode="r")

dump_file = open(sys.argv[2], mode="w")

rows = f.read().split("\n")

dump_file.write("""
    CREATE TABLE evi.worker
    (
        worker_id text COLLATE pg_catalog."default" NOT NULL,
        last_name text COLLATE pg_catalog."default" NOT NULL,
        first_name text COLLATE pg_catalog."default" NOT NULL,
        patronymic text COLLATE pg_catalog."default" NOT NULL,
        organization text COLLATE pg_catalog."default",
        division text COLLATE pg_catalog."default",
        "position" text COLLATE pg_catalog."default",
        employment_date text COLLATE pg_catalog."default" NOT NULL,
        dismissal_date text COLLATE pg_catalog."default" NOT NULL,
        status text COLLATE pg_catalog."default" NOT NULL,
        mobile text COLLATE pg_catalog."default" NOT NULL,
        email text COLLATE pg_catalog."default" NOT NULL,
        birth_date text COLLATE pg_catalog."default",
        photo text COLLATE pg_catalog."default",
        last_location text COLLATE pg_catalog."default",
        analytics boolean NOT NULL,
        access_level integer DEFAULT 0,
        CONSTRAINT worker_pkey PRIMARY KEY (worker_id),
        CONSTRAINT worker_access_level_fkey FOREIGN KEY (access_level)
            REFERENCES evi.access_level_worker (value) MATCH SIMPLE
            ON UPDATE CASCADE
            ON DELETE SET NULL,
        CONSTRAINT worker_division_fkey FOREIGN KEY (division)
            REFERENCES evi.divisions (division_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE SET NULL,
        CONSTRAINT worker_last_location_fkey FOREIGN KEY (last_location)
            REFERENCES evi.location (location_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE SET NULL,
        CONSTRAINT worker_organization_fkey FOREIGN KEY (organization)
            REFERENCES evi.organizations (organization_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE SET NULL,
        CONSTRAINT worker_photo_fkey FOREIGN KEY (photo)
            REFERENCES evi.photo (photo_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE SET NULL,
        CONSTRAINT worker_position_fkey FOREIGN KEY ("position")
            REFERENCES evi.positions (position_id) MATCH SIMPLE
            ON UPDATE NO ACTION
            ON DELETE SET NULL
    );
\n""")

for row in rows:
    if len(row) == 0:
        continue

    cols = row.split(",")
    record = WorkerRecord(cols[0], cols[1], cols[2], cols[3], cols[4], cols[5], cols[6], cols[7], cols[8], cols[9], cols[10], cols[11],
    cols[12], cols[13], cols[14], cols[15])

    if record.analytics == "t":
        record.analytics = "true"
    else:
        record.analytics = "false"

    photo_str = f"'{record.photo}'" if record.photo else "NULL"
    last_location_str = f"'{record.last_location}'" if record.last_location else "NULL"
    organization_str = f"'{record.organization}'" if record.organization else "NULL"
    division_str = f"'{record.division}'" if record.division else "NULL"
    position_str = f"'{record.position}'" if record.position else "NULL"
    access_level_str = record.access_level if record.access_level else "NULL"

    dump_file.write(f"""INSERT INTO evi.worker (worker_id, last_name, first_name, patronymic, organization, division,
                     position, employment_date, dismissal_date, status,
                     mobile, email, photo, last_location, analytics, access_level)
                     VALUES ('{record.worker_id}', '{record.last_name}', '{record.first_name}', '{record.patronymic}',
                    {organization_str}, {division_str}, {position_str}, '{record.employment_date}',
                    '{record.dismissal_date}', '{record.status}', '{record.mobile}', '{record.email}',
                    {photo_str}, {last_location_str}, {record.analytics}, {access_level_str});\n""")
