#!/bin/bash
set -e 

has_command() {
    type "$1" >/dev/null 2>&1
}

if [ "$USER" != "root" ] && [ "$(whoami)" != "root" ]; then
    echo "Для выполнения скрипта нужны права sudo, запустите скрипт с правами суперпользователя" >&2
    exit 1
fi

if systemctl --version >/dev/null 2>&1 && pidof systemd >/dev/null 2>&1; then
    exit 1
fi

echo ""
echo "PostgreSQL"

# PostgreSQL
if has_command psql; then
    # Проверка наличия сервиса PostgreSQL
    if systemctl list-units | grep -q 'postgresql.*running'; then
        echo "PostgreSQL запущен через systemctl"
        su postgres -c "psql -c \"CREATE USER core;\"" || true
        su postgres -c "psql -c \"ALTER USER core WITH PASSWORD 'core';\"" || true
        su postgres -c "psql -c \"ALTER USER core WITH SUPERUSER;\"" || true
        su postgres -c "psql -c \"CREATE DATABASE core;\"" || true
    elif has_command service && service --status-all | grep -q '\[ + \] postgresql'; then
        echo "PostgreSQL запущен через service"
        service postgresql start
        su postgres -c "psql -c \"CREATE USER core;\"" || true
        su postgres -c "psql -c \"ALTER USER core WITH PASSWORD 'core';\"" || true
        su postgres -c "psql -c \"ALTER USER core WITH SUPERUSER;\"" || true
        su postgres -c "psql -c \"CREATE DATABASE core;\"" || true
    else
        echo "PostgreSQL не установлен или не запущен" >&2
        exit 1
    fi
else
    echo "[ERROR] Утилита 'psql' не найдена. PostgreSQL не будет настроен." >&2
    exit 1
fi

echo ""
echo "ClickHouse"

# ClickHouse
if has_command clickhouse-client; then
    # Проверка наличия сервиса ClickHouse
    if systemctl list-units | grep -q 'clickhouse-server.*running'; then
        echo "ClickHouse запущен через systemctl"

        # Отключить trace_log (если нужно)
        cat << EOH > /etc/clickhouse-server/config.d/disable_trace_log.xml
<clickhouse>
    <trace_log remove="1"/>
</clickhouse>
EOH

        clickhouse-client --user=default --password=core --query="CREATE USER core IDENTIFIED WITH sha256_password BY 'core'" --query="GRANT CURRENT GRANTS on *.* TO core WITH GRANT OPTION" || true

        systemctl restart clickhouse-server
    elif has_command service && service --status-all | grep -q '\[ + \]\|\[ - \] clickhouse-server'; then
        echo "ClickHouse запущен через service"
        service clickhouse-server restart
        clickhouse-client --user=default --password=core --query="CREATE USER core IDENTIFIED WITH sha256_password BY 'core'" --query="GRANT CURRENT GRANTS on *.* TO core WITH GRANT OPTION" || true
    else
        echo "ClickHouse не установлен или не запущен" >&2
        exit 1
    fi
else
    echo "[ERROR] Утилита 'clickhouse-client' не найдена. ClickHouse не будет настроен." >&2
    exit 1
fi

exit 0
